package main

import (
	"fmt"
	"github.com/veandco/go-sdl2/img"
	"github.com/veandco/go-sdl2/sdl"
	"os"
)

var winTitle string = "Go-SDL2 Texture"
var winWidth, winHeight int32 = 800, 600
var imageName string = "kasa.png"
var imagebaloName string = "balo.png"
var imagebgName string = "j.png"

func run() int {
	var window *sdl.Window
	var renderer *sdl.Renderer
	var texture *sdl.Texture
	var texturebg *sdl.Texture
	var texturebalo *sdl.Texture
	//var dst sdl.Rect var src, dst ,srcbg,dstbg sdl.Rect
	var err error

	window, err = sdl.CreateWindow(winTitle, sdl.WINDOWPOS_UNDEFINED, sdl.WINDOWPOS_UNDEFINED, winWidth, winHeight, sdl.WINDOW_SHOWN)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Failed to create window: %s\n", err)
		return 1
	}
	defer window.Destroy()
	renderer, err = sdl.CreateRenderer(window, -1, sdl.RENDERER_ACCELERATED)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Faled to create renderer:%s\n", err)
		return 1
	}
	defer renderer.Destroy()

	imagebg, err := img.Load(imagebgName)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Failed to load PNG: %s\n", err)
		return 3
	}
	defer imagebg.Free()
	image, err := img.Load(imageName)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Failed to load PNG: %s\n", err)
		return 3
	}
	defer image.Free()
	imagebalo, err := img.Load(imagebaloName)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Failed to load PNG: %s\n", err)
		return 3
	}
	defer imagebalo.Free()

	texturebg, err = renderer.CreateTextureFromSurface(imagebg)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Failed to create texture: %s\n", err)
		return 4
	}
	defer texturebg.Destroy()
	texture, err = renderer.CreateTextureFromSurface(image)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Failed to create texture: %s\n", err)
		return 4
	}
	defer texture.Destroy()
	texturebalo, err = renderer.CreateTextureFromSurface(imagebalo)
	if err != nil {
		fmt.Fprintf(os.Stderr, "Failed to create texture: %s\n", err)
		return 4
	}
	defer texture.Destroy()
	var src = sdl.Rect{0, 0, 100, 100}
	var dst = sdl.Rect{0, 0, 100, 100}
	var src2 = sdl.Rect{0, 0, 100, 100}
	var dst2 = sdl.Rect{0, 0, 100, 100}
	var src3 = sdl.Rect{0, 0, 100, 100}
	var dst3 = sdl.Rect{0, 0, 100, 100}
	var src4 = sdl.Rect{0, 0, 100, 100}
	var dst4 = sdl.Rect{0, 0, 100, 100}
	var src5 = sdl.Rect{0, 0, 100, 100}
	var dst5 = sdl.Rect{0, 0, 100, 100}
	var src6 = sdl.Rect{0, 0, 100, 100}
	var dst6 = sdl.Rect{0, 0, 100, 100}
	var srcbg = sdl.Rect{0, 0, 800, 600}
	var dstbg = sdl.Rect{0, 0, 800, 600}
	dst2.X = -100
	dst3.X = -200
	dst4.X = -300
	dst5.X = -400
	dst6.X = -500
	var i int32
	i = 0
	//	for i := 0; i < 10; i++ {
	for {
		i++

		dst.Y = 250
		dst.X = dst.X + int32(i)
		dst2.Y = 250
		dst2.X = dst2.X + int32(i)
		dst3.Y = 250
		dst3.X = dst3.X + int32(i)
		dst4.Y = 250
		dst4.X = dst4.X + int32(i)
		dst5.Y = 250
		dst5.X = dst5.X + int32(i)
		dst6.Y = 250
		dst6.X = dst6.X + int32(i)
		//aaa
		//renderer.SetDrawColor(255, 0, 0, 255)
		//		renderer.FillRect(&sdl.Rect{0, 0, int32(winWidth), int32(winHeight)})
		//renderer.Copy(texture, &sdl.Rect{ 32, 10, 500, 400}, &dst)
		//renderer.Copy(texture, &sdl.Rect{0, 0, 50 - int32(i), 50}, &sdl.Rect{0, 0, 50 + int32(i), 50})
		renderer.Copy(texturebg, &srcbg, &dstbg)
		renderer.Copy(texture, &src, &dst)
		renderer.Copy(texture, &src2, &dst2)
		renderer.Copy(texture, &src3, &dst3)
		renderer.Copy(texture, &src4, &dst4)
		renderer.Copy(texture, &src5, &dst5)
		renderer.Copy(texturebalo, &src6, &dst6)
		renderer.Present()
		renderer.Clear()
		sdl.Delay(100)

	}

	return 0
}
func main() {
	os.Exit(run())
}
